<?php
session_start();
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'officer') {
  header("Location: ../auth/login.php");
  exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Report Incident</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head>
<body class="bg-light">
<div class="container mt-5">
  <h4 class="mb-3">🚨 Submit Incident Report</h4>

  <?php if (isset($_GET['success'])): ?>
    <div class="alert alert-success">Incident submitted successfully!</div>
  <?php endif; ?>

  <form action="submit_officer_incident.php" method="POST" enctype="multipart/form-data" class="bg-white p-4 rounded shadow-sm">
    <div class="mb-3">
      <label class="form-label">Incident Title</label>
      <input type="text" name="title" class="form-control" required>
    </div>

    <div class="mb-3">
      <label class="form-label">Description</label>
      <textarea name="description" rows="4" class="form-control" required></textarea>
    </div>

    <div class="row">
      <div class="col-md-6 mb-3">
        <label class="form-label">Date</label>
        <input type="date" name="incident_date" value="<?= date('Y-m-d') ?>" class="form-control" required>
      </div>
      <div class="col-md-6 mb-3">
        <label class="form-label">Time</label>
        <input type="time" name="incident_time" value="<?= date('H:i') ?>" class="form-control" required>
      </div>
    </div>

    <div class="mb-3">
      <label class="form-label">Select Site</label>
      <select name="site_id" class="form-select" required>
        <option value="">-- Choose Site --</option>
        <?php
        require_once '../includes/config.php';
        $sites = $pdo->query("SELECT id, site_name FROM sites ORDER BY site_name")->fetchAll();
        foreach ($sites as $site) {
          echo "<option value=\"{$site['id']}\">{$site['site_name']}</option>";
        }
        ?>
      </select>
    </div>

    <div class="mb-3">
      <label class="form-label">Attach Photo (optional)</label>
      <input type="file" name="photo" class="form-control" accept="image/*">
    </div>

    <div class="mb-3">
      <label class="form-label">Attach Video (optional)</label>
      <input type="file" name="video" class="form-control" accept="video/*">
    </div>

    <button type="submit" class="btn btn-primary">Submit Incident</button>
  </form>
</div>
</body>
</html>
